


export class VatEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/sales/vat/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteVat" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveVat" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuw btw-tarief':'Bewerk btw-tarief'}}</h1>
		</div>
		
		
		<form id="frmVat" action="{{appUrl('/service/sales/vat.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="vatId" value="{{vat.vatId}}" />
			
			<ez-text name="description" label="Omschrijving" [value]="vat.description"></ez-text>
			
			<ez-text name="percentage" label="Btw %" [value]="vat.percentage"></ez-text>
			
			<ez-checkbox name="visible" label="Zichtbaar" [checked]="vat.visible"></ez-checkbox>
			<ez-checkbox name="defaultSelected" label="Standaard gekozen" [checked]="vat.defaultSelected"></ez-checkbox>
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="vat.edited"></ez-datetime-text>
			
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="vat.created"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	vat = {
		description: '',
		visible: true
	};
	
	isNew = false;
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadVat( id );
		}
		else {
			this.isNew = true;
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('vat', this.vat);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		focusFirstField( '#frmVat' );
	}
	
	
	saveVat() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmVat').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmVat', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data!
				gotoRoute( '/masterdata/sales/vat/edit/?id=' + json.vatId );
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
	}
	
	deleteVat() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je dit btw-tarief wilt verwijderen?', function() {
			
			postUrl( '/service/sales/vat.do', {
				a: 'delete',
				vatId: this.vat.vatId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + e.message);
					return;
				}
				
				gotoRoute( '/masterdata/sales/vat/' );
			}.bind(this) );
			
		}.bind(this));
	}
	
	
	
	loadVat(vatId) {
		postUrl( '/service/sales/vat.do', {
			a: 'view',
			vatId: vatId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.vat = json.vat;
			this.render();
			
			this.loading = false;
		}.bind(this)); 
	}
	
}


